<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Sertifikat
    </h2>
    <a href="<?= base_url('admin/certificates') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/certificates/store') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_sertifikat" class="form-label">Nama Sertifikat <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_sertifikat" name="nama_sertifikat" 
                       value="<?= old('nama_sertifikat') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="penerbit" class="form-label">Penerbit</label>
                <input type="text" class="form-control" id="penerbit" name="penerbit" 
                       value="<?= old('penerbit') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tanggal_terbit" class="form-label">Tanggal Terbit</label>
                <input type="date" class="form-control" id="tanggal_terbit" name="tanggal_terbit" 
                       value="<?= old('tanggal_terbit') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tanggal_expired" class="form-label">Tanggal Expired</label>
                <input type="date" class="form-control" id="tanggal_expired" name="tanggal_expired" 
                       value="<?= old('tanggal_expired') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="nomor_sertifikat" class="form-label">Nomor Sertifikat</label>
                <input type="text" class="form-control" id="nomor_sertifikat" name="nomor_sertifikat" 
                       value="<?= old('nomor_sertifikat') ?>">
            </div>
        </div>

        <div class="mb-3">
            <label for="link_sertifikat" class="form-label">Link Sertifikat</label>
            <input type="url" class="form-control" id="link_sertifikat" name="link_sertifikat" 
                   value="<?= old('link_sertifikat') ?>" placeholder="https://...">
        </div>

        <div class="mb-3 position-relative">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi sertifikat..."><?= old('deskripsi') ?></textarea>
            

        </div>

        <div class="mb-3">
            <label for="foto_sertifikat" class="form-label">Foto Sertifikat</label>
            <input type="file" class="form-control" id="foto_sertifikat" name="foto_sertifikat" 
                   accept="image/jpeg,image/png,application/pdf">
            <small class="text-white">Format: JPG, PNG, PDF (Max: 5MB)</small>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/certificates') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<style>
/* Force button to be clickable - inline override */
#generateBtn {
    pointer-events: auto !important;
    cursor: pointer !important;
    z-index: 999999 !important;
    position: relative !important;
    display: inline-block !important;
}
</style>

